///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK EditSQLOptionsDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND SQLServer_hWnd = NULL;
    static HWND DataBase_hWnd  = NULL;
    static HWND DBDriver_hWnd  = NULL;
    static HWND UserName_hWnd  = NULL;
    static HWND Password_hWnd  = NULL;


	if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
	{
		EditSQLOptionsDialog_hWnd = xHandle;

		SendMessage(EditSQLOptionsDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"SQL Options");
		SendMessage(EditSQLOptionsDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(100)));

        SQLServer_hWnd = GetDlgItem(EditSQLOptionsDialog_hWnd, 1000);
        DataBase_hWnd  = GetDlgItem(EditSQLOptionsDialog_hWnd, 1001);
        DBDriver_hWnd  = GetDlgItem(EditSQLOptionsDialog_hWnd, 1002);
        UserName_hWnd  = GetDlgItem(EditSQLOptionsDialog_hWnd, 2000);
        Password_hWnd  = GetDlgItem(EditSQLOptionsDialog_hWnd, 2001);

        Set_Text(SQLServer_hWnd, BT[ESD.EditItem].SQLServer);
        Set_Text(DataBase_hWnd,  BT[ESD.EditItem].Database);
        Set_Text(DBDriver_hWnd,  BT[ESD.EditItem].DBDriver);
        Set_Text(UserName_hWnd,  BT[ESD.EditItem].Username);
        Set_Text(Password_hWnd,  BT[ESD.EditItem].Password);

        if(BT[ESD.EditItem].IsTrusted == TRUE)
            CheckDlgButton(EditSQLOptionsDialog_hWnd, 3000, BST_CHECKED);

 		CenterWindow(EditSQLOptionsDialog_hWnd);

		return 0;
	}


	if(xMessage == WM_COMMAND) // Received A Message
	{
		if(wParam == 100) //- Ok (Dialog Command)
		{
            char *xSQLServer = Get_Text(SQLServer_hWnd);
            char *xDataBase  = Get_Text(DataBase_hWnd);
            char *xDBDriver  = Get_Text(DBDriver_hWnd);
            char *xUserName  = Get_Text(UserName_hWnd);
            char *xPassword  = Get_Text(Password_hWnd);

            if( strlen(xSQLServer) < 1)
            {
                MessageBox(EditSQLOptionsDialog_hWnd, "You must specify a SQL server.", TitleCaption, 0);
                return 0;
            }

            if( strlen(xDataBase) < 1)
            {
                MessageBox(EditSQLOptionsDialog_hWnd, "You must specify a SQL data base.", TitleCaption, 0);
                return 0;
            }

            if( strlen(xDBDriver) < 1)
            {
                MessageBox(EditSQLOptionsDialog_hWnd, "You must specify a data base driver.", TitleCaption, 0);
                return 0;
            }

            SQLOD.SQLServer = xSQLServer;
            SQLOD.DataBase  = xDataBase;
            SQLOD.DBDriver  = xDBDriver;
            SQLOD.UserName  = xUserName;
            SQLOD.Password  = xPassword;

            if(IsDlgButtonChecked(EditSQLOptionsDialog_hWnd, 3000))
                SQLOD.IsTrusted = TRUE;
            else SQLOD.IsTrusted = FALSE;

            SQLOD.Complete = TRUE;

			EndDialog(EditSQLOptionsDialog_hWnd,0);
			return 0;
		}

		if(wParam==101) //- Cancel (Dialog Command)
		{
			EndDialog(EditSQLOptionsDialog_hWnd,0);
			return 0;
		}

		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

